/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntitySongbird
extends EntityAnimalWithSelectiveTypes
implements FlyingAnimal {
    protected static final EntityDataAccessor<Boolean> LANDED = SynchedEntityData.m_135353_(EntitySongbird.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final Set<Item> SEEDS = Sets.newHashSet((Object[])new Item[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    public float flapSpeed = 1.0f;
    private float nextFlap = 1.0f;

    public EntitySongbird(EntityType<? extends EntitySongbird> entityType, Level worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 180, true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        Predicate<LivingEntity> avoidPredicate = input -> {
            boolean result1 = input instanceof Player;
            boolean result2 = !SEEDS.contains(input.m_21120_(InteractionHand.MAIN_HAND).m_41720_()) && !SEEDS.contains(input.m_21120_(InteractionHand.OFF_HAND).m_41720_());
            return result1 && result2;
        };
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, avoidPredicate, 10.0f, 0.8, 1.0, e -> true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, (double)0.4f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_142469_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        if (world instanceof Level && !((Level)world).m_46749_(new BlockPos((Vec3i)blockpos))) {
            BlockState state = this.f_19853_.m_8055_(blockpos.m_7495_());
            Block block = state.m_60734_();
            return block instanceof LeavesBlock || block == Blocks.f_50034_ || state.m_204336_(BlockTags.f_13106_) || block == Blocks.f_50016_ && this.f_19853_.m_46803_(blockpos) > 8 && super.m_5545_(world, reason);
        }
        return super.m_5545_(world, reason);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation pathnavigateflying = new FlyingPathNavigation((Mob)this, worldIn);
        pathnavigateflying.m_26440_(false);
        pathnavigateflying.m_7008_(true);
        pathnavigateflying.m_26443_(true);
        return pathnavigateflying;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LANDED, (Object)true);
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        if (this.f_19853_.m_46749_(this.m_142538_().m_7495_())) {
            BlockState state = this.f_19853_.m_8055_(this.m_142538_().m_7495_());
            this.f_19804_.m_135381_(LANDED, (Object)(this.f_19861_ || this.m_20186_() == Math.floor(this.m_20186_()) && state.m_60816_((BlockGetter)this.f_19853_, this.m_142538_().m_7495_()).m_83297_(Direction.Axis.Y) == 1.0 && state.m_60838_((BlockGetter)this.f_19853_, this.m_142538_().m_7495_()) ? 1 : 0));
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return SEEDS.contains(stack.m_41720_());
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    protected void m_142043_() {
        this.m_5496_(SoundEvents.f_12191_, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_142592_() {
        return (Boolean)this.f_19804_.m_135370_(LANDED) == false;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (super.m_7848_(otherAnimal)) {
            if (!(otherAnimal instanceof EntitySongbird)) {
                return false;
            }
            return !this.getVariantNameOrEmpty().isEmpty() && !((EntitySongbird)otherAnimal).getVariantNameOrEmpty().isEmpty() && ((EntitySongbird)otherAnimal).getVariantNameOrEmpty().equals(this.getVariantNameOrEmpty());
        }
        return false;
    }

    @Override
    protected EntitySongbird getBaseChild() {
        return (EntitySongbird)this.getContainer().getEntityType().m_20615_(this.f_19853_);
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.FOREST) && !types.contains(BiomeTypes.CONIFEROUS)) {
            return new String[]{"2", "small_2", "small_3", "small_4"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS) && !types.contains(BiomeTypes.SNOWY)) {
            return new String[]{"1", "small_5", "small_6"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS) && types.contains(BiomeTypes.SNOWY)) {
            return new String[]{"3", "4", "small_1"};
        }
        return new String[]{"1", "2", "3", "4", "small_1", "small_2", "small_3", "small_4", "small_5", "small_6"};
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    public EntityTypeContainer<EntitySongbird> getContainer() {
        return ModEntities.SONGBIRD;
    }

    public static boolean canSongbirdSpawn(EntityType<EntitySongbird> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        BlockState below = world.m_8055_(pos.m_7495_());
        return Mob.m_21400_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand) || below.m_204336_(BlockTags.f_13035_) || below.m_204336_(BlockTags.f_13106_);
    }
}

